/*
 * Decompiled with CFR 0.152.
 */
package com.alexander.mutantmore.config;

import net.minecraftforge.common.ForgeConfigSpec;

public final class MutantBlazeCommonConfig {
    public static final ForgeConfigSpec.Builder BUILDER = new ForgeConfigSpec.Builder();
    public static final ForgeConfigSpec SPEC;
    public static final ForgeConfigSpec.ConfigValue<Integer> exp_reward;
    public static final ForgeConfigSpec.ConfigValue<Double> max_health;
    public static final ForgeConfigSpec.ConfigValue<Double> movement_speed;
    public static final ForgeConfigSpec.ConfigValue<Double> flying_strafe_speed;
    public static final ForgeConfigSpec.ConfigValue<Double> flying_strafe_direction_change_speed;
    public static final ForgeConfigSpec.ConfigValue<Double> flying_movement_speed;
    public static final ForgeConfigSpec.ConfigValue<Double> flying_vertical_speed;
    public static final ForgeConfigSpec.ConfigValue<Double> knockback_resistance;
    public static final ForgeConfigSpec.ConfigValue<Double> armour;
    public static final ForgeConfigSpec.ConfigValue<Double> armour_toughness;
    public static final ForgeConfigSpec.ConfigValue<Double> follow_player_distance;
    public static final ForgeConfigSpec.ConfigValue<Double> follow_non_player_distance;
    public static final ForgeConfigSpec.ConfigValue<Double> fireball_damage;
    public static final ForgeConfigSpec.ConfigValue<Double> fireball_explosion_damage;
    public static final ForgeConfigSpec.ConfigValue<Double> fireball_explosion_radius;
    public static final ForgeConfigSpec.ConfigValue<Integer> fireball_set_mob_on_fire_length;
    public static final ForgeConfigSpec.ConfigValue<Double> rod_damage;
    public static final ForgeConfigSpec.ConfigValue<Integer> rod_set_mob_on_fire_length;
    public static final ForgeConfigSpec.ConfigValue<Boolean> stunnable;
    public static final ForgeConfigSpec.ConfigValue<Double> stun_shockwave_damage;
    public static final ForgeConfigSpec.ConfigValue<Integer> stun_shockwave_set_mob_on_fire_length;
    public static final ForgeConfigSpec.ConfigValue<Integer> stun_shockwave_disable_shield_length;
    public static final ForgeConfigSpec.ConfigValue<Double> stun_shockwave_area;
    public static final ForgeConfigSpec.ConfigValue<Boolean> ignores_invulnerability_time;
    public static final ForgeConfigSpec.ConfigValue<Integer> shield_regenerate_speed;
    public static final ForgeConfigSpec.ConfigValue<Boolean> uses_fireball_attack;
    public static final ForgeConfigSpec.ConfigValue<Boolean> uses_rod_shot_attack;
    public static final ForgeConfigSpec.ConfigValue<Boolean> uses_flight_ability;
    public static final ForgeConfigSpec.ConfigValue<Boolean> avoids_corridors;
    public static final ForgeConfigSpec.ConfigValue<Boolean> avoids_target;
    public static final ForgeConfigSpec.ConfigValue<Double> avoid_target_max_range;
    public static final ForgeConfigSpec.ConfigValue<Double> stop_avoiding_target_min_distance;
    public static final ForgeConfigSpec.ConfigValue<Double> avoid_target_movement_speed_multiplier;
    public static final ForgeConfigSpec.ConfigValue<Double> flee_corridors_movement_speed_multiplier;
    public static final ForgeConfigSpec.ConfigValue<Boolean> attacks_players;
    public static final ForgeConfigSpec.ConfigValue<Double> following_movement_speed_multiplier;
    public static final ForgeConfigSpec.ConfigValue<Double> follow_target_wanted_distance;
    public static final ForgeConfigSpec.ConfigValue<Integer> flight_health_threshold;
    public static final ForgeConfigSpec.ConfigValue<Double> flight_below_target_start_distance;
    public static final ForgeConfigSpec.ConfigValue<Integer> stop_flying_time;
    public static final ForgeConfigSpec.ConfigValue<Double> flight_height;
    public static final ForgeConfigSpec.ConfigValue<Integer> flight_land_search_range_horizontal;
    public static final ForgeConfigSpec.ConfigValue<Integer> flight_land_search_range_vertical;
    public static final ForgeConfigSpec.ConfigValue<Double> flight_approach_target_min_distance;
    public static final ForgeConfigSpec.ConfigValue<Double> flight_avoid_target_max_distance;
    public static final ForgeConfigSpec.ConfigValue<Integer> flight_cooldown;
    public static final ForgeConfigSpec.ConfigValue<Integer> shoot_extra_fireballs_health_threshold_1;
    public static final ForgeConfigSpec.ConfigValue<Integer> shoot_extra_fireballs_health_threshold_2;
    public static final ForgeConfigSpec.ConfigValue<Integer> shoot_cooldown;
    public static final ForgeConfigSpec.ConfigValue<Integer> rod_shot_cooldown;
    public static final ForgeConfigSpec.ConfigValue<Integer> rodling_shot_max_nearby_rodlings;
    public static final ForgeConfigSpec.ConfigValue<Integer> rodling_shot_rodling_amount;
    public static final ForgeConfigSpec.ConfigValue<Integer> rodling_shot_armoured_rodlings_health_threshold;
    public static final ForgeConfigSpec.ConfigValue<Integer> rodling_shot_shielded_rodlings_health_threshold;
    public static final ForgeConfigSpec.ConfigValue<Integer> rodling_shot_shoot_armoured_rodlings_chance;
    public static final ForgeConfigSpec.ConfigValue<Integer> rodling_shot_shoot_shielded_rodlings_chance;
    public static final ForgeConfigSpec.ConfigValue<Boolean> explode_into_parts;
    public static final ForgeConfigSpec.ConfigValue<Boolean> parts_glow;
    public static final ForgeConfigSpec.ConfigValue<Double> part_collision_damage;
    public static final ForgeConfigSpec.ConfigValue<Integer> part_set_mob_on_fire_length;
    public static final ForgeConfigSpec.ConfigValue<Integer> part_persist_length;
    public static final ForgeConfigSpec.ConfigValue<Integer> part_amount;
    public static final ForgeConfigSpec.ConfigValue<Integer> rodling_part_amount;
    public static final ForgeConfigSpec.ConfigValue<Boolean> walk_griefing;
    public static final ForgeConfigSpec.ConfigValue<Boolean> walk_griefing_drops_blocks;
    public static final ForgeConfigSpec.ConfigValue<Boolean> fireball_griefing;
    public static final ForgeConfigSpec.ConfigValue<Boolean> fireball_griefing_drops_blocks;
    public static final ForgeConfigSpec.ConfigValue<Boolean> fireball_explosion_fire;
    public static final ForgeConfigSpec.ConfigValue<Boolean> rod_griefing;
    public static final ForgeConfigSpec.ConfigValue<Boolean> rod_griefing_drops_blocks;
    public static final ForgeConfigSpec.ConfigValue<Boolean> rod_fire;
    public static final ForgeConfigSpec.ConfigValue<Boolean> heat_griefing;
    public static final ForgeConfigSpec.ConfigValue<Integer> heat_griefing_chance;
    public static final ForgeConfigSpec.ConfigValue<Boolean> hurt_griefing;
    public static final ForgeConfigSpec.ConfigValue<Boolean> hurt_griefing_drops_blocks;
    public static final ForgeConfigSpec.ConfigValue<Double> heat_range;
    public static final ForgeConfigSpec.ConfigValue<Double> heat_range_y;
    public static final ForgeConfigSpec.ConfigValue<Double> heat_speed;
    public static final ForgeConfigSpec.ConfigValue<Boolean> heats_fire_immune_mobs;
    public static final ForgeConfigSpec.ConfigValue<Boolean> despawns;
    public static final ForgeConfigSpec.ConfigValue<Boolean> spawns_naturally;
    public static final ForgeConfigSpec.ConfigValue<Integer> natural_spawn_chance;

    static {
        BUILDER.comment("Configure Mutant More's Mutant Blaze on the client and server sides (these changes will affect everyone in the world)! The game needs to be restarted for changes to take effect!\n \n Stat Options:").push("stat_config");
        exp_reward = BUILDER.comment("\n The amount of Experience dropped by the Mutant Blaze when it dies\n usually set to 50").define("Experience Reward", (Object)50);
        max_health = BUILDER.comment("\n The Mutant Blaze's max health\n usually set to 300").define("Max Health", (Object)300.0);
        movement_speed = BUILDER.comment("\n The Mutant Blaze's movement speed\n usually set to 0.25").define("Movement Speed", (Object)0.25);
        flying_strafe_speed = BUILDER.comment("\n The speed of the Mutant Blaze's strafing while it flies\n usually set to 0.2").define("Flying Strafe Speed", (Object)0.2);
        flying_strafe_direction_change_speed = BUILDER.comment("\n The speed that the Mutant Blaze changes direction while strafing\n usually set to 0.004").define("Flying Strafe Direction Change Speed", (Object)0.004);
        flying_movement_speed = BUILDER.comment("\n The speed that the Mutant Blaze follows its target while flying\n usually set to 0.25").define("Flying Movement Speed", (Object)0.25);
        flying_vertical_speed = BUILDER.comment("\n The speed that the Mutant Blaze moves vertically while flying\n usually set to 0.1").define("Flying Vertical Speed", (Object)0.1);
        knockback_resistance = BUILDER.comment("\n The Mutant Blaze's resistance to attack knockback\n usually set to 1.0 (no knockback)").define("Knockback Resistance", (Object)1.0);
        armour = BUILDER.comment("\n The Mutant Blaze's armour value\n usually set to 10.0").define("Armour", (Object)10.0);
        armour_toughness = BUILDER.comment("\n The Mutant Blaze's armour toughness value\n usually set to 0.0").define("Armour Toughness", (Object)0.0);
        follow_player_distance = BUILDER.comment("\n The distance that the Mutant Blaze can target players from\n usually set to 64.0").define("Follow Player Distance", (Object)64.0);
        follow_non_player_distance = BUILDER.comment("\n The distance that the Mutant Blaze can target non-player entities from\n usually set to 25.0").define("Follow Non-Player Distance", (Object)25.0);
        fireball_damage = BUILDER.comment("\n The damage that the Mutant Blaze's fireballs deal\n usually set to 12.0").define("Fireball Damage", (Object)12.0);
        fireball_explosion_damage = BUILDER.comment("\n The damage dealt to mobs caught in an explosion created by one of the Mutant Blaze's fireballs\n usually set to 10.0").define("Fireball Explosion Damage", (Object)10.0);
        fireball_explosion_radius = BUILDER.comment("\n The radius of the explosions created by the Mutant Blaze's fireballs\n usually set to 3.0").define("Fireball Explosion Radius", (Object)3.0);
        fireball_set_mob_on_fire_length = BUILDER.comment("\n The amount of time in seconds that mobs are set on fire for when hit by one of the Mutant Blaze's fireballs\n usually set to 5 seconds").define("Fireball Set Mob On Fire Length", (Object)5);
        rod_damage = BUILDER.comment("\n The damage that the Mutant Blaze's rod projectiles deal\n usually set to 4.0").define("Rod Damage", (Object)4.0);
        rod_set_mob_on_fire_length = BUILDER.comment("\n The amount of time in seconds that mobs are set on fire for when hit by one of the Mutant Blaze's rod projectiles\n usually set to 3 seconds").define("Rod Set Mob On Fire Length", (Object)3);
        stunnable = BUILDER.comment("\n If the Mutant Blaze gets stunned briefly when directly hit by one of its own fireballs\n usually set to true").define("Stunnable", true);
        stun_shockwave_damage = BUILDER.comment("\n The damage dealt by the Mutant Blaze's shockwave attack, performed after it has been stunned\n usually set to 20.0").define("Stun Shockwave Damage", (Object)20.0);
        stun_shockwave_set_mob_on_fire_length = BUILDER.comment("\n The amount of time in seconds that mobs are set on fire for when hit by the Mutant Blaze's shockwave attack, performed after it has been stunned\n usually set to 7 seconds").define("Stun Shockwave Set Mob On Fire Length", (Object)7);
        stun_shockwave_disable_shield_length = BUILDER.comment("\n The amount of time in ticks (20 ticks in a second) that the Mutant Blaze disables mobs' shields for if they block its shockwave attack, performed after it has been stunned\n usually set to 100 ticks (5 seconds)").define("Stun Shockwave Disable Shield Length", (Object)100);
        stun_shockwave_area = BUILDER.comment("\n The area around the Mutant Blaze that it can harm mobs in when using its shockwave attack, performed after it has been stunned\n usually set to 7.5").define("Stun Shockwave Area", (Object)7.5);
        ignores_invulnerability_time = BUILDER.comment("\n If the Mutant Blaze's attacks ignore the brief invulnerability mobs get when damaged\n Makes sure the Mutant Blaze's attacks always hit when they're supposed to\n usually set to true").define("Ignores Invulnerability Time", true);
        shield_regenerate_speed = BUILDER.comment("\n The amount of time in ticks (20 ticks in a second) that it takes for the Mutant Blaze to regenerate a broken shield\n usually set to 200 ticks (10 seconds)").define("Shield Regenerate Time", (Object)200);
        BUILDER.pop();
        BUILDER.comment("\n \n AI Options:").push("ai_config");
        uses_fireball_attack = BUILDER.comment("\n If the Mutant Blaze uses its fireball attack\n usually set to true").define("Uses Fireball Attack", true);
        uses_rod_shot_attack = BUILDER.comment("\n If the Mutant Blaze uses its rod shot attack\n usually set to true").define("Uses Rod Shot Attack", true);
        uses_flight_ability = BUILDER.comment("\n If the Mutant Blaze uses its flight ability\n usually set to true").define("Uses Flight Ability", true);
        avoids_corridors = BUILDER.comment("\n If the Mutant Blaze avoids and tries to escape areas where it is forced to crouch (which would prevent it from flying)\n usually set to true").define("Avoids Corridors", true);
        avoids_target = BUILDER.comment("\n If the Mutant Blaze tries to run away from its target if they get too close to it\n usually set to true").define("Avoids Target", true);
        avoid_target_max_range = BUILDER.comment("\n The maximum distance from its target that the Mutant Blaze can be to run away from them\n usually set to 10.0").define("Avoid Target Maximum Range", (Object)10.0);
        stop_avoiding_target_min_distance = BUILDER.comment("\n The minimum distance from its target that the Mutant Blaze can be to stop running away from them\n usually set to 15.0").define("Stop Avoiding Target Minimum Distance", (Object)15.0);
        avoid_target_movement_speed_multiplier = BUILDER.comment("\n The amount that the Mutant Blaze's movement speed is multiplied when it's running away from its target\n usually set to 1.35").define("Avoid Target Movement Speed Multiplier", (Object)1.35);
        flee_corridors_movement_speed_multiplier = BUILDER.comment("\n The amount that the Mutant Blaze's movement speed is multiplied when it's trying to escape an area where it is forced to crouch\n usually set to 1.5").define("Flee Corridors Movement Speed Multiplier", (Object)1.5);
        attacks_players = BUILDER.comment("\n If the Mutant Blaze attacks players\n usually set to true").define("Attacks Players", true);
        following_movement_speed_multiplier = BUILDER.comment("\n The amount that the Mutant Blaze's movement speed is multiplied when it's pursuing a target\n usually set to 1.35").define("Following Movement Speed Multiplier", (Object)1.35);
        follow_target_wanted_distance = BUILDER.comment("\n The distance to its target that the Mutant Blaze tries to reach\n usually set to 20.0").define("Follow Target Wanted Distance", (Object)20.0);
        flight_health_threshold = BUILDER.comment("\n The percentage of max health that the Mutant Blaze must be at or below to start flying\n usually set to 50%").define("Flight Health Threshold", (Object)50);
        flight_below_target_start_distance = BUILDER.comment("\n The distance below its target that the Mutant Blaze must be to start flying regardless of its health\n usually set to 10.0 blocks below its target").define("Flight Below Target Start Distance", (Object)10.0);
        stop_flying_time = BUILDER.comment("\n The amount of time in ticks (20 ticks in a second) that the Mutant Blaze can fly for before attempting to land\n usually set to 300 ticks (15 seconds)").define("Stop Flying Time", (Object)300);
        flight_height = BUILDER.comment("\n The height above its target or desired landing spot that the Mutant Blaze flys at\n usually set to 2.0").define("Flight Height", (Object)2.0);
        flight_land_search_range_horizontal = BUILDER.comment("\n The horizontal area that the Mutant Blaze searches for a valid landing spot in\n usually set to 15").define("Flight Land Search Range Horizontal", (Object)15);
        flight_land_search_range_vertical = BUILDER.comment("\n The vertical area that the Mutant Blaze searches for a valid landing spot in\n usually set to 10").define("Flight Land Search Range Vertical", (Object)10);
        flight_approach_target_min_distance = BUILDER.comment("\n The minimum distance from its target that the Mutant Blaze must be to start approaching its target while flying\n usually set to 20.0").define("Flight Approach Target Minimum Distance", (Object)20.0);
        flight_avoid_target_max_distance = BUILDER.comment("\n The maximum distance from its target that the Mutant Blaze must be to start avoiding its target while flying\n usually set to 15.0").define("Flight Avoid Target Maximum Distance", (Object)15.0);
        flight_cooldown = BUILDER.comment("\n The amount of time in ticks (20 ticks in a second) that must pass after flying before the Mutant Blaze can start to fly again\n usually set to 400 ticks (20 seconds)").define("Flight Cooldown", (Object)400);
        shoot_extra_fireballs_health_threshold_1 = BUILDER.comment("\n The percentage of max health that the Mutant Blaze must be at or below to shoot 2 extra fireballs\n usually set to 75%").define("Shoot Extra Fireballs Health Threshold 1", (Object)75);
        shoot_extra_fireballs_health_threshold_2 = BUILDER.comment("\n The percentage of max health that the Mutant Blaze must be at or below to shoot another 2 extra fireballs\n usually set to 50%").define("Shoot Extra Fireballs Health Threshold 2", (Object)50);
        shoot_cooldown = BUILDER.comment("\n The amount of time in ticks (20 ticks in a second) that must pass after shooting a fireball before the Mutant Blaze can shoot again\n usually set to 100 ticks (5 seconds)").define("Shoot Cooldown", (Object)100);
        rod_shot_cooldown = BUILDER.comment("\n The amount of time in ticks (20 ticks in a second) that must pass after using the rod shot attack before the Mutant Blaze can use rod shot again\n usually set to 600 ticks (30 seconds)").define("Rod Shot Cooldown", (Object)600);
        rodling_shot_max_nearby_rodlings = BUILDER.comment("\n The maximum amount of hostile Rodlings that can be nearby for the Mutant Blaze to be able to shoot Rodlings while using its rod shot attack\n usually set to 1").define("Rodling Shot Maximum Nearby Rodlings", (Object)1);
        rodling_shot_rodling_amount = BUILDER.comment("\n The amount of Rodlings shot by the Mutant Blaze when using its rod shot attack\n usually set to 2").define("Rodling Shot Rodling Amount", (Object)2);
        rodling_shot_armoured_rodlings_health_threshold = BUILDER.comment("\n The percentage of max health that the Mutant Blaze must be at or below to have a chance of shooting armoured Rodlings when using its rod shot attack\n usually set to 50%").define("Rodling Shot Armoured Rodlings Health Threshold", (Object)50);
        rodling_shot_shielded_rodlings_health_threshold = BUILDER.comment("\n The percentage of max health that the Mutant Blaze must be at or below to have a chance of shooting shielded Rodlings when using its rod shot attack\n usually set to 25%").define("Rodling Shot Shielded Rodlings Health Threshold", (Object)25);
        rodling_shot_shoot_armoured_rodlings_chance = BUILDER.comment("\n The chance in percent that the Mutant Blaze will shoot an armoured Rodling when using it's rod shot attack when below a certain amount of health\n usually set to 50%").define("Rodling Shot Shoot Armoured Rodlings Chance", (Object)50);
        rodling_shot_shoot_shielded_rodlings_chance = BUILDER.comment("\n The chance in percent that the Mutant Blaze will shoot a shielded Rodling when using it's rod shot attack when below a certain amount of health\n usually set to 50%").define("Rodling Shot Shoot Shielded Rodlings Chance", (Object)50);
        BUILDER.pop();
        BUILDER.comment("\n \n Death Options:").push("death_config");
        explode_into_parts = BUILDER.comment("\n If the Mutant Blaze explodes into its parts upon death\n setting to false will make it drop the loot from loot table data/mutantmore/loot_tables/entities/mutant_blaze_part in addition to its regular loot\n usually set to true").define("Explode Into Parts", true);
        parts_glow = BUILDER.comment("\n If the parts the Mutant Blaze explodes into upon death have a glowing effect, making them easier to find, lowers immersion\n usually set to false").define("Parts Glow", false);
        part_collision_damage = BUILDER.comment("\n The damage that the parts the Mutant Blaze explodes into upon death deal when colliding with an entity\n usually set to 8.0").define("Part Collision Damage", (Object)8.0);
        part_set_mob_on_fire_length = BUILDER.comment("\n The amount of time in ticks (20 ticks in a second) that the parts the Mutant Blaze explodes into upon death wither mobs they collide with for\n usually set to 150 ticks (7.5 seconds)").define("Part Collision Set Mob On Fire Length", (Object)150);
        part_persist_length = BUILDER.comment("\n The amount of time in ticks (20 ticks in a second) that the parts the Mutant Blaze explodes into upon death persist for before despawning\n usually set to 6000 ticks (5 minutes)").define("Part Persist Length", (Object)6000);
        part_amount = BUILDER.comment("\n The amount of parts that the Mutant Blaze explodes into upon death\n usually set to 32").define("Part Amount", (Object)32);
        rodling_part_amount = BUILDER.comment("\n The amount of parts that the Mutant Blaze explodes into upon death that are replaced by tamable Rodlings\n usually set to 1").define("Rodling Part Amount", (Object)1);
        BUILDER.pop();
        BUILDER.comment("\n \n Griefing Options:").push("griefing_config");
        walk_griefing = BUILDER.comment("\n If the Mutant Blaze breaks certain types of blocks it walks into, helps with pathfinding\n usually set to true").define("Walk Griefing", true);
        walk_griefing_drops_blocks = BUILDER.comment("\n If blocks the Mutant Blaze breaks by walking drop themselves as items, allowing them to be recovered, impacts performance\n usually set to false").define("Walk Griefing Drops Blocks", false);
        fireball_griefing = BUILDER.comment("\n If the Mutant Blaze's fireballs break blocks when they explode\n usually set to true").define("Fireball Griefing", true);
        fireball_griefing_drops_blocks = BUILDER.comment("\n If blocks the Mutant Blaze's fireballs break when exploding drop themselves as items, allowing them to be recovered, impacts performance\n usually set to false").define("Fireball Griefing Drops Blocks", false);
        fireball_explosion_fire = BUILDER.comment("\n If the Mutant Blaze's fireballs create fire when they explode\n usually set to true").define("Fireball Explosion Fire", true);
        rod_griefing = BUILDER.comment("\n If the Mutant Blaze's rod projectiles break blocks that they collide with\n usually set to true").define("Rod Griefing", true);
        rod_griefing_drops_blocks = BUILDER.comment("\n If blocks the Mutant Blaze's rod projectiles break on collision drop themselves as items, allowing them to be recovered, impacts performance\n usually set to false").define("Rod Griefing Drops Blocks", false);
        rod_fire = BUILDER.comment("\n If the Mutant Blaze's rod projectiles set fire to blocks they hit\n usually set to true").define("Rod Fire", true);
        heat_griefing = BUILDER.comment("\n If the Mutant Blaze sets nearby blocks on fire\n usually set to true").define("Heat Griefing", true);
        heat_griefing_chance = BUILDER.comment("\n The chance per tick (20 ticks in a second) that the Mutant Blaze will try to set a nearby block on fire\n usually set to 1 in 20").define("Heat Griefing Chance", (Object)20);
        hurt_griefing = BUILDER.comment("\n If the Mutant Blaze breaks blocks around it after getting hurt, similarly to the Wither, helps prevent cheesing\n usually set to true").define("Hurt Griefing", true);
        hurt_griefing_drops_blocks = BUILDER.comment("\n If blocks the Mutant Blaze breaks after getting hurt drop themselves as items, allowing them to be recovered, impacts performance\n usually set to false").define("Hurt Griefing Drops Blocks", true);
        BUILDER.pop();
        BUILDER.comment("\n \n Heat Options:").push("heat_config");
        heat_range = BUILDER.comment("\n The horizontal distance to the Mutant Blaze mobs need to be to start heating up\n usually set to 10.0").define("Heat Range", (Object)10.0);
        heat_range_y = BUILDER.comment("\n The vertical distance to the Mutant Blaze mobs need to be to start heating up\n usually set to 5.0").define("Heat Range Y", (Object)5.0);
        heat_speed = BUILDER.comment("\n The amount per tick (there are 20 ticks per second) that mobs heat up when near the Mutant Blaze\n usually set to 0.005").define("Heat Speed", (Object)0.005);
        heats_fire_immune_mobs = BUILDER.comment("\n If the Mutant Blaze can heat and damage mobs that are immune to fire\n usually set to false").define("Heats Fire Immune Mobs", false);
        BUILDER.pop();
        BUILDER.comment("\n \n Spawn Options:").push("spawn_config");
        despawns = BUILDER.comment("\n If the Mutant Blaze naturally despawnsNot recommended unless Spawns Naturally is set to true\n usually set to false").define("Despawns", false);
        spawns_naturally = BUILDER.comment("\n If a Blaze has a chance to be replaced by a Mutant Blaze when spawning\n usually set to false").define("Spawns Naturally", false);
        natural_spawn_chance = BUILDER.comment("\n How often a Blaze is replaced by a Mutant Blaze when spawning\n usually set to 1 in 100").define("Natural Spawn Chance", (Object)100);
        BUILDER.pop();
        SPEC = BUILDER.build();
    }
}

